package com.agilex.healthcare.veteranappointment.validator;

import com.agilex.healthcare.mobilehealthplatform.validator.ValidatorHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.veteranappointment.domain.VARPatientPreference;

import java.util.Arrays;
import java.util.List;

public class PreferenceValidator {
	
	public ValidationResult<VARPatientPreference> validate(VARPatientPreference pref) {
		
		ValidationResult<VARPatientPreference> validationResult = new ValidationResult<VARPatientPreference>();
		
		validateEmail(pref, validationResult);
		
		validatePhNumber(pref, validationResult);

        validatePreferenceFrequency(pref, validationResult);
		
		return validationResult;
	}

    private void validatePreferenceFrequency(VARPatientPreference pref, ValidationResult<VARPatientPreference> validationResult) {
        String[] validValues = {"Each new message", "Daily", "Never"};
        List<String> validValuesList =  Arrays.asList(validValues);
        if (!validValuesList.contains(pref.getNotificationFrequency())){
             validationResult.addIfNotNull(new ValidationError("Invalid Notification Frequency", "notificationFrequency"));
        }
    }

    private void validatePhNumber(VARPatientPreference pref,
			ValidationResult<VARPatientPreference> validationResult) {
		String phoneNumber = pref.getTextMsgPhNumber();
        if(NullChecker.isNotNullish(phoneNumber)){
            if (!ValidatorHelper.isPhoneNumberLengthValid(phoneNumber) ||
                    !ValidatorHelper.isPhoneNumberHasMinDigits(phoneNumber) ||
                    !ValidatorHelper.isPhoneNumberValidCharacters(phoneNumber)){

                validationResult.addIfNotNull(new ValidationError("Phone must have a minimum of 10 digits and only contain digits and these characters: + ( ) - . x space", "textMsgPhNumber"));
            }
        }
	}

	private void validateEmail(VARPatientPreference pref,
			ValidationResult<VARPatientPreference> validationResult) {
		validationResult.setRequestObject(pref);
		String email = pref.getEmailAddress();
        if(NullChecker.isNotNullish(email)){

            if (!ValidatorHelper.isEmailLengthValid(email)
                    || !ValidatorHelper.isEmailAddressFormatValid(email)) {
                validationResult
                        .addIfNotNull(new ValidationError(
                                "Email must be between 3 and 50 characters in a valid email format",
                                "emailAddress"));
            }
        }
    }
}
